using System.Collections.Generic;
using UnityEngine;

public class StageGenerator : MonoBehaviour
{
    const int StageChipSize = 30;

    public Transform Character;
    public GameObject[] StageChips;
    public int StartChipIndex;
    public int PreInstantiate;
    public List<GameObject> GeneratedStageList = new List<GameObject>();

    int _currentChipIndex;

    void Start()
    {
        _currentChipIndex = StartChipIndex - 1;
        UpdateStage(PreInstantiate);
    }

    void Update()
    {
        // キャラクターの位置から現在のステージチップのインデックスを計算
        int charaPositionIndex = (int)(Character.position.z / StageChipSize);

        // 次のステージチップに入ったらステージの更新処理をおこなう
        if (charaPositionIndex + PreInstantiate > _currentChipIndex)
        {
            UpdateStage(charaPositionIndex + PreInstantiate);
        }
    }

    // 指定のIndexまでのステージチップを生成して、管理化に置く
    void UpdateStage(int toChipIndex)
    {
        if (toChipIndex <= _currentChipIndex) return;

        // 指定のステージチップまでを作成
        for (int i = _currentChipIndex + 1; i <= toChipIndex; i++)
        {
            GameObject stageObject = GenerateStage(i);

            // 生成したステージチップを管理リストに追加
            GeneratedStageList.Add(stageObject);
        }

        // ステージ保持上限内になるまで古いステージを削除
        while (GeneratedStageList.Count > PreInstantiate + 2) DestroyOldestStage();
        _currentChipIndex = toChipIndex;
    }

    // 指定のインデックス位置にStageオブジェクトをランダムに生成
    GameObject GenerateStage(int chipIndex)
    {
        int nextStageChip = Random.Range(0, StageChips.Length);
        GameObject stageObject = (GameObject)Instantiate(
            StageChips[nextStageChip],
            new Vector3(0, 0, chipIndex * StageChipSize),
            Quaternion.identity
        );
        return stageObject;
    }

    // 一番古いステージを削除
    void DestroyOldestStage()
    {
        GameObject oldStage = GeneratedStageList[0];
        GeneratedStageList.RemoveAt(0);
        Destroy(oldStage);
    }
}