using UnityEngine;
using UnityEngine.SceneManagement;
using UnityEngine.UI;

public class GameController : MonoBehaviour
{
    public NejikoController Nejiko;
    public Text ScoreText;
    public LifePanel LifePanel;

    public void Update()
    {
        // スコアを更新
        int score = CalcScore();
        ScoreText.text = "Score : " + score + "m";

        // ライフパネルを更新
        LifePanel.UpdateLife(Nejiko.Life());

        // ねじ子のライフが0になったらゲームオーバー
        if (Nejiko.Life() <= 0)
        {
            // これ以降のUpdateは止める
            enabled = false;

            // ハイスコアを更新
            if (PlayerPrefs.GetInt("HighScore") < score)
            {
                PlayerPrefs.SetInt("HighScore", score);
            }

            // 2秒後にReturnToTitleを呼びだす
            Invoke("ReturnToTitle", 2.0f);
        }
    }

    int CalcScore()
    {
        // ねじ子の走行距離をスコアとする
        return (int)Nejiko.transform.position.z;
    }

    void ReturnToTitle()
    {
        // タイトルシーンに切り替え
        SceneManager.LoadScene("Title");
    }
}