using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.InputSystem;

public class Shooter : MonoBehaviour
{
    const int MaxShotPower = 5;
    const int RecoverySeconds = 3;

    public GameObject[] CookiePrefabs;
    public Transform CookieParentTransform;
    public CookieManager CookieManager;
    public float ShotForce;
    public float ShotTorque;
    public float BaseWidth;

    InputAction _fireAction;
    int _shotPower = MaxShotPower;
    AudioSource _shotSound;

    void Start()
    {
        _fireAction = InputSystem.actions.FindAction("Attack");
        _shotSound = GetComponent<AudioSource>();
    }

    void Update()
    {
        if (_fireAction.WasPressedThisFrame()) Shot();
    }

    // クッキーのプレハブからランダムに1つ選ぶ
    GameObject SampleCookie()
    {
        int index = Random.Range(0, CookiePrefabs.Length);
        return CookiePrefabs[index];
    }

    Vector3 GetInstantiatePosition()
    {
        // 画面のサイズとInputの割合からクッキー生成のポジションを計算
        float x = BaseWidth *
        (Mouse.current.position.ReadValue().x / Screen.width) - (BaseWidth / 2);
        return transform.position + new Vector3(x, 0, 0);
    }

    public void Shot()
    {
        // クッキーを生成できる条件外ならばShotしない
        if (CookieManager.GetCookieAmount() <= 0) return;
        if (_shotPower <= 0) return;

        // プレハブからCookieオブジェクトを生成
        GameObject cookie = (GameObject)Instantiate(
            SampleCookie(),
            GetInstantiatePosition(),
            Quaternion.identity
        );

        // 生成したCookieオブジェクトの親をCookieHolderに設定する
        cookie.transform.parent = CookieParentTransform;

        // CadnyオブジェクトのRigidbodyを取得し力と回転を加える
        Rigidbody CookieRigidBody = cookie.GetComponent<Rigidbody>();
        CookieRigidBody.AddForce(transform.forward * ShotForce);
        CookieRigidBody.AddTorque(new Vector3(0, ShotTorque, 0));

        // Cookieのストックを消費
        CookieManager.ConsumeCookie();

        // ShotPowerを消費
        ConsumePower();

        // サウンドを再生
        _shotSound.Play();
    }

    void OnGUI()
    {
        GUI.color = Color.black;
        // ShotPowerの残数を+の数で表示
        string label = "";
        for (int i = 0; i < _shotPower; i++) label = label + "+";
        GUI.matrix = Matrix4x4.Scale(Vector3.one * 2);
        GUI.Label(new Rect(10, 25, 100, 30), label);
    }

    void ConsumePower()
    {
        // ShotPowerを消費すると同時に回復のカウントをスタート
        _shotPower--;
        StartCoroutine(RecoverPower());
    }

    IEnumerator RecoverPower()
    {
        // 一定秒数待った後にshotPowerを回復
        yield return new WaitForSeconds(RecoverySeconds);
        _shotPower++;
    }
}
