using UnityEngine;

public class Pusher : MonoBehaviour
{
    public float Amplitude;
    public float Speed;

    Vector3 _startPosition;

    void Start()
    {
        _startPosition = transform.localPosition;
    }

    void Update()
    {
        // 変位を計算
        float z = Amplitude * Mathf.Sin(Time.time * Speed);
        // zを変位させたポジションに再設定
        transform.localPosition = _startPosition + new Vector3(0, 0, z);
    }
}