using System.Collections;
using UnityEngine;

public class CookieManager : MonoBehaviour
{
    const int DefaultCookieAmount = 30;
    const int RecoverySeconds = 10;

    // 現在のクッキーのストック数
    public int Cookie = DefaultCookieAmount;

    // ストック回復までの残り秒数
    int _counter;

    public void ConsumeCookie()
    {
        if (Cookie > 0) Cookie--;
    }

    public int GetCookieAmount()
    {
        return Cookie;
    }

    public void AddCookie(int amount)
    {
        Cookie += amount;
    }

    void OnGUI()
    {
        GUI.color = Color.black;
        // クッキーのストック数を表示
        string label = "Cookie : " + Cookie;

        // 回復カウントしている時だけ秒数を表示
        if (_counter > 0) label = label + " (" + _counter + "s)";
        GUI.matrix = Matrix4x4.Scale(Vector3.one * 2);
        GUI.Label(new Rect(10, 10, 100, 30), label);
    }

    void Update()
    {
        // クッキーのストックがデフォルトより少なく、
        // 回復カウントをしていないときにカウントをスタートさせる
        if (Cookie < DefaultCookieAmount && _counter <= 0)
        {
            StartCoroutine(RecoverCookie());
        }
    }

    IEnumerator RecoverCookie()
    {
        _counter = RecoverySeconds;

        // 1秒ずつカウントを進める
        while (_counter > 0)
        {
            yield return new WaitForSeconds(1.0f);
            _counter--;
        }
        Cookie++;
    }
}