using UnityEngine;

public class CookieDestroyer : MonoBehaviour
{
    public CookieManager CookieManager;
    public int Reward;
    public GameObject EffectPrefab;
    public Vector3 EffectRotation;

    void OnTriggerEnter(Collider other)
    {
        if (other.transform.parent.tag == "Cookie")
        {
            // 指定数だけCookieのストックを増やす
            CookieManager.AddCookie(Reward);

            // オブジェクトを削除
            Destroy(other.transform.parent.gameObject);

            if (EffectPrefab != null)
            {
                // Cookieのポジションにエフェクトを生成
                Instantiate(
                EffectPrefab,
                other.transform.position,
                Quaternion.Euler(EffectRotation)
                );
            }
        }
    }
}