using UnityEngine;

public class ScrollObject : MonoBehaviour
{
    public float Speed = 1.0f;
    public float StartPosition;
    public float EndPosition;

    void Update()
    {
        // 毎フレームxポジションを少しずつ移動させる
        transform.Translate(-1 * Speed * Time.deltaTime, 0, 0);

        // スクロールが目標ポイントまで到達したかをチェック
        if (transform.position.x <= EndPosition) ScrollEnd();
    }

    void ScrollEnd()
    {
        // EndPositionから超えた距離を加味してポジションを再設定
        float diff = transform.position.x - EndPosition;
        Vector3 restartPosition = transform.position;
        restartPosition.x = StartPosition + diff;
        transform.position = restartPosition;

        // 同じゲームオブジェクトにアタッチされているコンポーネントにメッセージを送る
        SendMessage("OnScrollEnd", SendMessageOptions.DontRequireReceiver);
    }
}