using UnityEngine;
using UnityEngine.InputSystem;
using UnityEngine.SceneManagement;
using UnityEngine.UI;

public class GameController : MonoBehaviour
{
    // ゲームステート
    enum State
    {
        Ready,
        Play,
        GameOver
    }

    State _state;
    InputAction _inputAttack;
    int _score;

    public AzarashiController Azarashi;
    public GameObject Blocks;
    public Text ScoreText;
    public Text StateText;

    void Start()
    {
        // タッチ操作のための準備
        _inputAttack = InputSystem.actions.FindAction("Attack");
        // 開始と同時にReadyステートに移行
        Ready();
    }

    void LateUpdate()
    {
        // ゲームのステートごとにイベントを監視
        switch (_state)
        {
            case State.Ready:
                // タッチしたらゲームスタート
                if (_inputAttack.WasPressedThisFrame()) GameStart();
                break;
            case State.Play:
                // キャラクターが死亡したらゲームオーバー
                if (Azarashi.IsDead) GameOver();
                break;
            case State.GameOver:
                // タッチしたらシーンをリロード
                if (_inputAttack.WasPressedThisFrame()) Reload();
                break;
        }
    }

    void Ready()
    {
        _state = State.Ready;

        // 各オブジェクトを無効状態にする
        Azarashi.SetSteerActive(false);
        Blocks.SetActive(false);

        // ラベルを更新
        ScoreText.text = "Score : " + 0;
        StateText.gameObject.SetActive(true);
        StateText.text = "Ready";
    }

    void GameStart()
    {
        _state = State.Play;

        // 各オブジェクトを有効にする
        Azarashi.SetSteerActive(true);
        Blocks.SetActive(true);

        // 最初の入力だけゲームコントローラーから渡す
        Azarashi.Flap();

        // ラベルを更新
        StateText.gameObject.SetActive(false);
        StateText.text = "";
    }

    void GameOver()
    {
        _state = State.GameOver;

        // シーン中のすべてのScrollObjectコンポーネントを探し出す
        ScrollObject[] scrollObjects = FindObjectsByType<ScrollObject>(FindObjectsSortMode.None);

        // 全ScrollObjectのスクロール処理を無効にする
        foreach (ScrollObject so in scrollObjects) so.enabled = false;

        // ラベルを更新
        StateText.gameObject.SetActive(true);
        StateText.text = "GameOver";
    }

    void Reload()
    {
        // 現在読み込んでいるシーンを再読込み
        string currentSceneName = SceneManager.GetActiveScene().name;
        SceneManager.LoadScene(currentSceneName);
    }

    public void IncreaseScore()
    {
        _score++;
        ScoreText.text = "Score : " + _score;
    }
}