using UnityEngine;

public class Block : MonoBehaviour
{
    public float MinHeight;
    public float MaxHeight;
    public GameObject Root;

    void Start()
    {
        // 開始時に隙間の高さを変更
        ChangeHeight();
    }

    void ChangeHeight()
    {
        // ランダムな高さを生成して設定
        float height = Random.Range(MinHeight, MaxHeight);
        Root.transform.localPosition = new Vector3(0.0f, height, 0.0f);
    }

    // ScrollObjectスクリプトからのメッセージを受け取って高さを変更
    void OnScrollEnd()
    {
        ChangeHeight();
    }
}