using UnityEngine;
using UnityEngine.InputSystem;

public class AzarashiController : MonoBehaviour
{
    public float MaxHeight;
    public float FlapVelocity;
    public float RelativeVelocityX;
    public GameObject Sprite;
    public bool IsDead => _isDead;

    Rigidbody2D _rb2d;
    InputAction _inputAttack;
    Animator _animator;
    float _angle;
    bool _isDead;

    void Awake()
    {
        // タッチ操作のための準備
        _inputAttack = InputSystem.actions.FindAction("Attack");

        _rb2d = GetComponent<Rigidbody2D>();
        _animator = Sprite.GetComponent<Animator>();
    }

    void Update()
    {
        // 最高高度に達していない場合に限りタップの入力を受け付ける
        if (_inputAttack.WasPressedThisFrame() && transform.position.y < MaxHeight)
        {
            Flap();
        }

        // 角度を反映
        ApplyAngle();

        // angleが水平以上だったら、アニメーターのflapフラグをtrueにする
        _animator.SetBool("flap", _angle >= 0.0f && !_isDead);
    }

    public void Flap()
    {
        // 死んだらはばたけない
        if (_isDead) return;

        // 重力が効いていないときは操作しない
        if (_rb2d.bodyType == RigidbodyType2D.Kinematic) return;

        // Velocityを直接書き換えて上方向に加速
        _rb2d.linearVelocity = new Vector2(0.0f, FlapVelocity);
    }

    void ApplyAngle()
    {
        // 現在の速度、相対速度から進んでいる角度を求める
        float targetAngle;

        // 死亡したら常にひっくり返る
        if (_isDead)
        {
            targetAngle = 180.0f;
        }
        else
        {
            targetAngle =
                Mathf.Atan2(_rb2d.linearVelocity.y, RelativeVelocityX) * Mathf.Rad2Deg;
        }

        // 回転アニメをスムージング
        _angle = Mathf.Lerp(_angle, targetAngle, Time.deltaTime * 10.0f);

        // Rotationの反映
        Sprite.transform.localRotation = Quaternion.Euler(0.0f, 0.0f, _angle);
    }

    void OnCollisionEnter2D(Collision2D collision)
    {
        if (_isDead) return;

        // クラッシュエフェクト
        Camera.main.SendMessage("Clash");

        // 何かにぶつかったら死亡フラグをたてる
        _isDead = true;
    }

    public void SetSteerActive(bool active)
    {
        // Rigidbodyのオン、オフを切り替える
        if (active)
        {
            _rb2d.bodyType = RigidbodyType2D.Dynamic;
        }
        else
        {
            _rb2d.bodyType = RigidbodyType2D.Kinematic;
        }
    }
}