﻿using UnityEngine;
using System.Collections;

class FlashEffect : MonoBehaviour
{
    private Texture2D _texture;
    private float _alpha;

    public static void Play()
    {
        GameObject go = new GameObject("Flash");
        go.AddComponent<FlashEffect>();
    }

    void Awake()
    {
        _texture = new Texture2D(4, 4, TextureFormat.RGB24, false);

        for (int y = 0; y < _texture.height; ++y)
        {
            for (int x = 0; x < _texture.width; ++x)
            {
                _texture.SetPixel(x, y, Color.white);
            }
        }

        _texture.Apply();
        _alpha = 1.0f;
    }

    void OnGUI()
    {
        float dim = Mathf.Clamp01(Time.deltaTime * 2.0f);
        _alpha = Mathf.Clamp01(_alpha - dim);

        GUI.color = new Color(1.0f, 1.0f, 1.0f, _alpha);
        GUI.DrawTexture(new Rect(0, 0, Screen.width, Screen.height), _texture);

        if (_alpha == 0.0f)
        {
            Destroy(gameObject);
        }
    }

    void OnDestroy()
    {
        Destroy(_texture);
    }
}